/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IncrementProjectVersion {
    private static final String[] VERSIONS = new String[]{"major", "minor", "patch", "build"};

    public static void main(String[] args) {
        String input;
        if (args.length == 1) {
            input = args[0];
        } else {
            try (Scanner scanner = new Scanner(System.in);){
                System.out.print("Version (" + String.join((CharSequence)".", VERSIONS) + ") [build]: ");
                input = scanner.nextLine();
            }
        }
        int index = 0;
        boolean valid = false;
        for (String string : VERSIONS) {
            if (string.equals(input)) {
                valid = true;
                break;
            }
            ++index;
        }
        if (!valid) {
            input = "build";
            index = VERSIONS.length - 1;
        }
        System.out.println("\nIncreasing " + input + " version...");
        File file = new File("./build.gradle");
        ArrayList<String> list = new ArrayList<String>(120);
        try {
            Throwable throwable = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    list.add(line);
                }
            }
            catch (Throwable line) {
                Throwable throwable2 = line;
                throw line;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String[] lines = list.toArray(new String[0]);
        Pattern pattern = Pattern.compile("([0-9]+\\.){3}[0-9]+");
        for (int i = 0; i < lines.length; ++i) {
            int versionValue;
            String line = lines[i];
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String version = matcher.group();
            Object[] versions = version.split("\\.");
            if (versions.length < index) {
                Object[] updatedVersions = new String[index];
                Arrays.fill(updatedVersions, "0");
                System.arraycopy(versions, 0, updatedVersions, 0, versions.length);
                versions = updatedVersions;
            }
            String value = versions[index];
            try {
                versionValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException(nfe);
            }
            versions[index] = String.valueOf(++versionValue);
            String versionStr = String.join((CharSequence)".", (CharSequence[])versions);
            lines[i] = line.replaceAll("([0-9]+\\.){3}[0-9]+", versionStr);
            break;
        }
        try (FileWriter writer = new FileWriter(file);){
            for (String line : lines) {
                writer.write(line + "\n");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

